/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.particle;

import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpListGenerator;
import com.teamwizardry.librarianlib.features.particle.ParticleBase;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderManager;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawn;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="librarianlib", value={Side.CLIENT})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002JN\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u00072\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0015H\u0007J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/teamwizardry/librarianlib/features/particle/ParticleSpawner;", "", "()V", "pending", "", "Lcom/teamwizardry/librarianlib/features/particle/ParticleSpawn;", "modifyParticleCount", "", "particleCount", "cappedParticleCount", "spawn", "", "builder", "Lcom/teamwizardry/librarianlib/features/particle/ParticleBuilder;", "world", "Lnet/minecraft/world/World;", "curve", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "Lnet/minecraft/util/math/Vec3d;", "travelTime", "callback", "Ljava/util/function/BiConsumer;", "", "tick", "tickEvent", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "librarianlib-1.12.2"})
public final class ParticleSpawner {
    private static Set<ParticleSpawn> pending;
    public static final ParticleSpawner INSTANCE;

    @JvmStatic
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static final void tickEvent(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiScreen gui = mc.field_71462_r;
            if (gui == null || !gui.func_73868_f()) {
                Minecraft minecraft = mc;
                Intrinsics.checkExpressionValueIsNotNull(minecraft, "mc");
                if (!minecraft.func_147113_T()) {
                    INSTANCE.tick();
                }
            }
        }
    }

    public final void tick() {
        Iterable $receiver$iv = pending;
        for (Object element$iv : $receiver$iv) {
            ParticleSpawn it = (ParticleSpawn)element$iv;
            if (it.getTicksTillSpawn() > 0) continue;
            ParticleRenderManager.spawn(it.getParticle());
        }
        CollectionsKt.removeAll((Iterable)pending, (Function1)tick.2.INSTANCE);
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount, int travelTime, @NotNull BiConsumer<Float, ParticleBuilder> callback) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(curve, "curve");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        int currentCount = ParticleRenderManager.getLAYER_BLOCK_MAP().getParticleList().size() + ParticleRenderManager.getLAYER_BLOCK_MAP_ADDITIVE().getParticleList().size();
        if (!(gui != null && gui.func_73868_f() || currentCount >= LibLibConfig.getMaxParticleCount())) {
            Minecraft minecraft = mc;
            Intrinsics.checkExpressionValueIsNotNull(minecraft, "mc");
            if (!minecraft.func_147113_T()) {
                int actualParticleCount = INSTANCE.modifyParticleCount(particleCount, LibLibConfig.getMaxParticleCount() - currentCount);
                Iterable $receiver$iv = InterpListGenerator.getIndexList(actualParticleCount);
                for (Object element$iv : $receiver$iv) {
                    float t = ((Number)element$iv).floatValue();
                    int tick2 = (int)Math.floor((double)t * (double)travelTime);
                    callback.accept(Float.valueOf(t), builder);
                    ParticleBase particle = builder.build(world, curve.get(t));
                    if (particle == null) continue;
                    pending.add(new ParticleSpawn(particle, tick2));
                }
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    public static /* synthetic */ void spawn$default(ParticleBuilder particleBuilder, World world, InterpFunction interpFunction, int n, int n2, BiConsumer biConsumer, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            biConsumer = spawn.1.INSTANCE;
        }
        ParticleSpawner.spawn(particleBuilder, world, interpFunction, n, n2, biConsumer);
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount, int travelTime) {
        ParticleSpawner.spawn$default(builder, world, curve, particleCount, travelTime, null, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount) {
        ParticleSpawner.spawn$default(builder, world, curve, particleCount, 0, null, 48, null);
    }

    private final int modifyParticleCount(int particleCount, int cappedParticleCount) {
        float f;
        switch (Minecraft.func_71410_x().field_71474_y.field_74362_aa) {
            case 0: {
                f = 1.0f;
                break;
            }
            case 1: {
                f = 0.5f;
                break;
            }
            case 2: {
                f = 0.25f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        float mul = f;
        return Math.min(cappedParticleCount, (int)Math.max(2.0f, (float)particleCount * mul));
    }

    private ParticleSpawner() {
    }

    static {
        ParticleSpawner particleSpawner;
        INSTANCE = particleSpawner = new ParticleSpawner();
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.newSetFromMap(ConcurrentHashMap())");
        pending = set;
    }
}

